/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.util;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.util.DeclarationScanner;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.util.Comparator;
import java.util.TreeSet;

class SourceOrderDeclScanner
extends DeclarationScanner {
    static final Comparator<Declaration> comparator = new SourceOrderComparator();

    SourceOrderDeclScanner(DeclarationVisitor declarationVisitor, DeclarationVisitor declarationVisitor2) {
        super(declarationVisitor, declarationVisitor2);
    }

    @Override
    public void visitTypeDeclaration(TypeDeclaration typeDeclaration) {
        typeDeclaration.accept(this.pre);
        TreeSet<Declaration> treeSet = new TreeSet<Declaration>(comparator);
        for (TypeParameterDeclaration declaration : typeDeclaration.getFormalTypeParameters()) {
            treeSet.add(declaration);
        }
        for (FieldDeclaration fieldDeclaration : typeDeclaration.getFields()) {
            treeSet.add(fieldDeclaration);
        }
        for (MethodDeclaration methodDeclaration : typeDeclaration.getMethods()) {
            treeSet.add(methodDeclaration);
        }
        for (TypeDeclaration typeDeclaration2 : typeDeclaration.getNestedTypes()) {
            treeSet.add(typeDeclaration2);
        }
        for (Declaration declaration : treeSet) {
            declaration.accept(this);
        }
        typeDeclaration.accept(this.post);
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) {
        classDeclaration.accept(this.pre);
        TreeSet<Declaration> treeSet = new TreeSet<Declaration>(comparator);
        for (TypeParameterDeclaration declaration : classDeclaration.getFormalTypeParameters()) {
            treeSet.add(declaration);
        }
        for (FieldDeclaration fieldDeclaration : classDeclaration.getFields()) {
            treeSet.add(fieldDeclaration);
        }
        for (MethodDeclaration methodDeclaration : classDeclaration.getMethods()) {
            treeSet.add(methodDeclaration);
        }
        for (TypeDeclaration typeDeclaration : classDeclaration.getNestedTypes()) {
            treeSet.add(typeDeclaration);
        }
        for (ConstructorDeclaration constructorDeclaration : classDeclaration.getConstructors()) {
            treeSet.add(constructorDeclaration);
        }
        for (Declaration declaration : treeSet) {
            declaration.accept(this);
        }
        classDeclaration.accept(this.post);
    }

    @Override
    public void visitExecutableDeclaration(ExecutableDeclaration executableDeclaration) {
        executableDeclaration.accept(this.pre);
        TreeSet<Declaration> treeSet = new TreeSet<Declaration>(comparator);
        for (TypeParameterDeclaration declaration : executableDeclaration.getFormalTypeParameters()) {
            treeSet.add(declaration);
        }
        for (ParameterDeclaration parameterDeclaration : executableDeclaration.getParameters()) {
            treeSet.add(parameterDeclaration);
        }
        for (Declaration declaration : treeSet) {
            declaration.accept(this);
        }
        executableDeclaration.accept(this.post);
    }

    static class SourceOrderComparator
    implements Comparator<Declaration> {
        SourceOrderComparator() {
        }

        static boolean equals(Declaration declaration, Declaration declaration2) {
            return declaration == declaration2 || declaration != null && ((Object)declaration).equals(declaration2);
        }

        private int compareEqualPosition(Declaration declaration, Declaration declaration2) {
            assert (declaration.getPosition() == declaration2.getPosition());
            DeclPartialOrder declPartialOrder = new DeclPartialOrder();
            DeclPartialOrder declPartialOrder2 = new DeclPartialOrder();
            declaration.accept(declPartialOrder);
            declaration2.accept(declPartialOrder2);
            int n = declPartialOrder.getValue() - declPartialOrder2.getValue();
            if (n != 0) {
                return n;
            }
            int n2 = declaration.getSimpleName().compareTo(declaration2.getSimpleName());
            if (n2 != 0) {
                return n2;
            }
            return Long.signum((long)System.identityHashCode(declaration) - (long)System.identityHashCode(declaration2));
        }

        @Override
        public int compare(Declaration declaration, Declaration declaration2) {
            if (SourceOrderComparator.equals(declaration, declaration2)) {
                return 0;
            }
            SourcePosition sourcePosition = declaration.getPosition();
            SourcePosition sourcePosition2 = declaration2.getPosition();
            if (sourcePosition == null && sourcePosition2 != null) {
                return 1;
            }
            if (sourcePosition != null && sourcePosition2 == null) {
                return -1;
            }
            if (sourcePosition == null && sourcePosition2 == null) {
                return this.compareEqualPosition(declaration, declaration2);
            }
            assert (sourcePosition != null && sourcePosition2 != null);
            int n = sourcePosition.file().compareTo(sourcePosition2.file());
            if (n == 0) {
                long l = (long)sourcePosition.line() - (long)sourcePosition2.line();
                if (l == 0L) {
                    l = Long.signum((long)sourcePosition.column() - (long)sourcePosition2.column());
                    if (l != 0L) {
                        return (int)l;
                    }
                    return this.compareEqualPosition(declaration, declaration2);
                }
                return l < 0L ? -1 : 1;
            }
            return n;
        }

        private static class DeclPartialOrder
        extends SimpleDeclarationVisitor {
            private int value = 1000;

            private static int staticAdjust(Declaration declaration) {
                return declaration.getModifiers().contains((Object)Modifier.STATIC) ? 0 : 1;
            }

            DeclPartialOrder() {
            }

            public int getValue() {
                return this.value;
            }

            @Override
            public void visitTypeParameterDeclaration(TypeParameterDeclaration typeParameterDeclaration) {
                this.value = 0;
            }

            @Override
            public void visitEnumConstantDeclaration(EnumConstantDeclaration enumConstantDeclaration) {
                this.value = 1;
            }

            @Override
            public void visitClassDeclaration(ClassDeclaration classDeclaration) {
                this.value = 2 + DeclPartialOrder.staticAdjust(classDeclaration);
            }

            @Override
            public void visitInterfaceDeclaration(InterfaceDeclaration interfaceDeclaration) {
                this.value = 4;
            }

            @Override
            public void visitEnumDeclaration(EnumDeclaration enumDeclaration) {
                this.value = 6;
            }

            @Override
            public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration annotationTypeDeclaration) {
                this.value = 8;
            }

            @Override
            public void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
                this.value = 10 + DeclPartialOrder.staticAdjust(fieldDeclaration);
            }

            @Override
            public void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
                this.value = 12;
            }

            @Override
            public void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
                this.value = 14 + DeclPartialOrder.staticAdjust(methodDeclaration);
            }
        }
    }
}

