/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class PackageList
extends Expand {
    private String property = null;
    private String pathSep = ",";
    private String dirSep = ".";
    private boolean includeemptydirs = false;
    TreeMap<String, IntegerContainer> packagelist = new TreeMap();
    private Vector<PatternSet> patternsets = new Vector();

    public void execute() throws BuildException {
        this.setDest(new File(" no file, files are only listed internaly"));
        super.execute();
        StringBuffer strb = new StringBuffer();
        for (String name : this.packagelist.keySet()) {
            if (!this.includeemptydirs && this.packagelist.get((Object)name).value <= 0) continue;
            if (strb.length() > 0) {
                strb.append(this.pathSep);
            }
            StringTokenizer stDirectory = new StringTokenizer(name, "/", true);
            while (stDirectory.hasMoreTokens()) {
                String token = stDirectory.nextToken();
                strb.append("/".equals(token) ? this.dirSep : token);
            }
        }
        if (this.property != null) {
            String value = strb.toString();
            this.getProject().setNewProperty(this.property, value);
        }
    }

    public void addPatternset(PatternSet set) {
        super.addPatternset(set);
        this.patternsets.addElement(set);
    }

    protected void extractFile(FileUtils i_fileUtils, File i_srcF, File i_dir, InputStream i_compressedInputStream, String i_entryName, Date i_entryDate, boolean i_isDirectory, FileNameMapper i_mapper) throws IOException {
        if (!this.matchPatterns(i_entryName)) {
            return;
        }
        String strDir = this.getDir(i_isDirectory, i_entryName);
        if (strDir != null && !"META-INF".equals(strDir)) {
            if (!this.packagelist.containsKey(strDir)) {
                this.packagelist.put(strDir, new IntegerContainer());
            }
            if (!i_isDirectory) {
                this.packagelist.get(strDir).inc();
            }
        }
    }

    private boolean matchPatterns(String i_entryName) {
        if (this.patternsets != null && this.patternsets.size() > 0) {
            boolean included = false;
            String name = i_entryName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            HashSet<String> includePatterns = new HashSet<String>();
            HashSet<String> excludePatterns = new HashSet<String>();
            int v = 0;
            int size = this.patternsets.size();
            while (v < size) {
                PatternSet p = this.patternsets.elementAt(v);
                String[] incls = p.getIncludePatterns(this.getProject());
                if (incls == null || incls.length == 0) {
                    incls = new String[]{"**"};
                }
                int w = 0;
                while (w < incls.length) {
                    String pattern = incls[w].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    if (pattern.endsWith(File.separator)) {
                        pattern = String.valueOf(pattern) + "**";
                    }
                    includePatterns.add(pattern);
                    ++w;
                }
                String[] excls = p.getExcludePatterns(this.getProject());
                if (excls != null) {
                    int w2 = 0;
                    while (w2 < excls.length) {
                        String pattern = excls[w2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                        if (pattern.endsWith(File.separator)) {
                            pattern = String.valueOf(pattern) + "**";
                        }
                        excludePatterns.add(pattern);
                        ++w2;
                    }
                }
                ++v;
            }
            Iterator iter = includePatterns.iterator();
            while (!included && iter.hasNext()) {
                String pattern = (String)iter.next();
                included = SelectorUtils.matchPath((String)pattern, (String)name);
            }
            iter = excludePatterns.iterator();
            while (included && iter.hasNext()) {
                String pattern = (String)iter.next();
                boolean bl = included = !SelectorUtils.matchPath((String)pattern, (String)name);
            }
            return included;
        }
        return true;
    }

    private String getDir(boolean i_isDirectory, String i_entryName) {
        if (i_entryName == null) {
            return null;
        }
        int iIndex = i_entryName.lastIndexOf(47);
        if (iIndex >= 0) {
            return i_entryName.substring(0, iIndex);
        }
        if (i_isDirectory) {
            return i_entryName;
        }
        return null;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    public void setPathSep(String sep) {
        this.pathSep = sep;
    }

    public void setDirSep(String sep) {
        this.dirSep = sep;
    }

    public boolean isIncludeemptydirs() {
        return this.includeemptydirs;
    }

    public void setIncludeemptydirs(boolean i_includeemptydirs) {
        this.includeemptydirs = i_includeemptydirs;
    }

    class IntegerContainer {
        int value;

        IntegerContainer() {
        }

        public void inc() {
            ++this.value;
        }
    }
}

