/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ant;

import org.apache.tools.ant.BuildException;
import org.junit.Assert;
import org.junit.Test;
import org.lwjgl.ant.NormalizeVersion;

public class NormalizeVersionTest {
    @Test
    public void testNormalizer() {
        NormalizeVersion t = new NormalizeVersion();
        t.setProperty("normalized");
        t.setVersion("1");
        Assert.assertEquals((Object)"1.0.0", (Object)t.doExecute());
        t.setVersion("1.2");
        Assert.assertEquals((Object)"1.2.0", (Object)t.doExecute());
        t.setVersion("1.2.3");
        Assert.assertEquals((Object)"1.2.3", (Object)t.doExecute());
        t.setVersion("1.2.3.beta");
        Assert.assertEquals((Object)"1.2.3.beta", (Object)t.doExecute());
        t.setVersion("1.2.beta");
        Assert.assertEquals((Object)"1.2.0.beta", (Object)t.doExecute());
    }

    @Test(expected=BuildException.class)
    public void tooManyDots() {
        NormalizeVersion t = new NormalizeVersion();
        t.setProperty("normalized");
        t.setVersion("1.2.3.4.5");
        t.doExecute();
    }

    @Test(expected=BuildException.class)
    public void qualifierWithNumber() {
        NormalizeVersion t = new NormalizeVersion();
        t.setProperty("normalized");
        t.setVersion("1.2beta");
        t.doExecute();
    }

    @Test
    public void testQualifier() {
        NormalizeVersion t = new NormalizeVersion();
        t.setProperty("normalized");
        t.setAddDateQualifier(true);
        t.setVersion("1");
        String s = t.doExecute();
        Assert.assertEquals((long)20L, (long)s.length());
        Assert.assertTrue((boolean)s.startsWith("1.0.0"));
        t.setVersion("1.2");
        s = t.doExecute();
        Assert.assertEquals((long)20L, (long)s.length());
        Assert.assertTrue((boolean)s.startsWith("1.2.0"));
        t.setVersion("1.2.3");
        s = t.doExecute();
        Assert.assertEquals((long)20L, (long)s.length());
        Assert.assertTrue((boolean)s.startsWith("1.2.3"));
        t.setVersion("2.8.2");
        s = t.doExecute();
        Assert.assertEquals((long)20L, (long)s.length());
        Assert.assertTrue((boolean)s.startsWith("2.8.2"));
    }

    @Test(expected=BuildException.class)
    public void dateQualifierWithQualifier() {
        NormalizeVersion t = new NormalizeVersion();
        t.setProperty("normalized");
        t.setAddDateQualifier(true);
        t.setVersion("1.2.beta");
        t.doExecute();
    }
}

