/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.EncodingType;

public class MSI
extends BarcodeCommon {
    private final String[] MSI_Code = new String[]{"100100100100", "100100100110", "100100110100", "100100110110", "100110100100", "100110100110", "100110110100", "100110110110", "110100100100", "110100100110"};
    private final EncodingType encodedType;

    public MSI(String input, EncodingType EncodedType) {
        this.encodedType = EncodedType;
        this.setRawData(input);
    }

    private String encodeMSI() {
        if (!MSI.checkNumericOnly(this.getRawData())) {
            this.error("EMSI-1: Numeric Data Only");
        }
        String withChecksum = "";
        if (this.encodedType == EncodingType.MSI_Mod10) {
            withChecksum = this.Mod10(this.getRawData());
        } else if (this.encodedType == EncodingType.MSI_Mod11) {
            withChecksum = this.Mod11(this.getRawData());
        } else if (this.encodedType == EncodingType.MSI_2Mod10) {
            withChecksum = this.Mod10(this.Mod10(this.getRawData()));
        } else if (this.encodedType == EncodingType.MSI_Mod11_Mod10) {
            withChecksum = this.Mod10(this.Mod11(this.getRawData()));
        }
        if (withChecksum.trim().length() <= 0) {
            this.error("EMSI-2: Invalid MSI encoding type");
        }
        String result = "110";
        char[] cArray = withChecksum.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            result = String.valueOf(result) + this.MSI_Code[Integer.parseInt(c.toString())];
            ++n2;
        }
        result = String.valueOf(result) + "1001";
        return result;
    }

    private String Mod10(String code) {
        Character c;
        String odds = "";
        String evens = "";
        char[] chars = code.toCharArray();
        int i = code.length() - 1;
        while (i >= 0) {
            odds = String.valueOf(chars[i]) + odds;
            if (i - 1 >= 0) {
                evens = String.valueOf(chars[i - 1]) + evens;
            }
            i -= 2;
        }
        odds = String.valueOf(Integer.parseInt(odds) * 2);
        int evensum = 0;
        int oddsum = 0;
        char[] cArray = evens.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = Character.valueOf(cArray[n2]);
            evensum += Integer.parseInt(c.toString());
            ++n2;
        }
        cArray = odds.toCharArray();
        n = cArray.length;
        n2 = 0;
        while (n2 < n) {
            c = Character.valueOf(cArray[n2]);
            oddsum += Integer.parseInt(c.toString());
            ++n2;
        }
        int mod = (oddsum + evensum) % 10;
        int checksum = mod == 0 ? 0 : 10 - mod;
        return String.valueOf(code) + checksum;
    }

    private String Mod11(String code) {
        int sum = 0;
        int weight = 2;
        char[] chars = code.toCharArray();
        int i = code.length() - 1;
        while (i >= 0) {
            if (weight > 7) {
                weight = 2;
            }
            sum += Integer.parseInt(String.valueOf(chars[i])) * weight++;
            --i;
        }
        int mod = sum % 11;
        int checksum = mod == 0 ? 0 : 11 - mod;
        return String.valueOf(code) + checksum;
    }

    public String getEncodedValue() {
        return this.encodeMSI();
    }
}

