/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.BarcodeCommon;

public class Code11
extends BarcodeCommon {
    private final String[] C11_Code = new String[]{"101011", "1101011", "1001011", "1100101", "1011011", "1101101", "1001101", "1010011", "1101001", "110101", "101101", "1011001"};

    public Code11(String input) {
        this.setRawData(input);
    }

    private String encodeCode11() {
        if (!Code11.checkNumericOnly(this.getRawData().replace("-", ""))) {
            this.error("EC11-1: Numeric data and '-' Only");
        }
        int weight = 1;
        int CTotal = 0;
        String dataToEncodeWithChecksums = this.getRawData();
        int i = this.getRawData().length() - 1;
        while (i >= 0) {
            if (weight == 10) {
                weight = 1;
            }
            CTotal = this.getRawData().charAt(i) != '-' ? (CTotal += Integer.parseInt(String.valueOf(this.getRawData().charAt(i))) * weight++) : (CTotal += 10 * weight++);
            --i;
        }
        int checksumC = CTotal % 11;
        dataToEncodeWithChecksums = String.valueOf(dataToEncodeWithChecksums) + String.valueOf(checksumC);
        if (this.getRawData().length() >= 10) {
            weight = 1;
            int KTotal = 0;
            int i2 = dataToEncodeWithChecksums.length() - 1;
            while (i2 >= 0) {
                if (weight == 9) {
                    weight = 1;
                }
                KTotal = dataToEncodeWithChecksums.charAt(i2) != '-' ? (KTotal += Integer.parseInt(String.valueOf(dataToEncodeWithChecksums.charAt(i2))) * weight++) : (KTotal += 10 * weight++);
                --i2;
            }
            int checksumK = KTotal % 9;
            dataToEncodeWithChecksums = String.valueOf(dataToEncodeWithChecksums) + checksumK;
        }
        return this.doEncoding(dataToEncodeWithChecksums);
    }

    private String doEncoding(String dataToEncodeWithChecksums) {
        String space = "0";
        StringBuilder builder = new StringBuilder();
        builder.append(this.C11_Code[11]);
        builder.append(space);
        char[] cArray = dataToEncodeWithChecksums.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int index = c == '-' ? 10 : Integer.parseInt(String.valueOf(c));
            builder.append(this.C11_Code[index]);
            builder.append(space);
            ++n2;
        }
        builder.append(this.C11_Code[11]);
        return builder.toString();
    }

    public String getEncodedValue() {
        return this.encodeCode11();
    }
}

