/*
 * Decompiled with CFR 0.152.
 */
package com.pnuema.java.barcode.symbologies;

import com.pnuema.java.barcode.Barcode;
import com.pnuema.java.barcode.BarcodeCommon;
import com.pnuema.java.barcode.IBarcode;

public class MSI
extends BarcodeCommon
implements IBarcode {
    private final String[] MSI_Code = new String[]{"100100100100", "100100100110", "100100110100", "100100110110", "100110100100", "100110100110", "100110110100", "100110110110", "110100100100", "110100100110"};
    private final Barcode.TYPE encodedType;

    public MSI(String input, Barcode.TYPE EncodedType) {
        this.encodedType = EncodedType;
        this.setRawData(input);
    }

    private String encodeMSI() {
        int n;
        int n2;
        char[] cArray;
        int oddsum;
        int evensum;
        int i;
        if (!MSI.checkNumericOnly(this.getRawData())) {
            this.error("EMSI-1: Numeric Data Only");
        }
        String PreEncoded = this.getRawData();
        if (this.encodedType == Barcode.TYPE.MSI_Mod10 || this.encodedType == Barcode.TYPE.MSI_2Mod10) {
            Character c;
            String odds = "";
            String evens = "";
            i = PreEncoded.length() - 1;
            while (i >= 0) {
                odds = String.valueOf(String.valueOf(PreEncoded.toCharArray()[i])) + odds;
                if (i - 1 >= 0) {
                    evens = String.valueOf(String.valueOf(PreEncoded.toCharArray()[i - 1])) + evens;
                }
                i -= 2;
            }
            odds = String.valueOf(Integer.parseInt(odds) * 2);
            evensum = 0;
            oddsum = 0;
            cArray = evens.toCharArray();
            n2 = cArray.length;
            n = 0;
            while (n < n2) {
                c = Character.valueOf(cArray[n]);
                evensum += Integer.parseInt(c.toString());
                ++n;
            }
            cArray = odds.toCharArray();
            n2 = cArray.length;
            n = 0;
            while (n < n2) {
                c = Character.valueOf(cArray[n]);
                oddsum += Integer.parseInt(c.toString());
                ++n;
            }
            int mod = (oddsum + evensum) % 10;
            int checksum = mod == 0 ? 0 : 10 - mod;
            PreEncoded = String.valueOf(PreEncoded) + String.valueOf(checksum);
        }
        if (this.encodedType == Barcode.TYPE.MSI_Mod11 || this.encodedType == Barcode.TYPE.MSI_Mod11_Mod10) {
            int sum = 0;
            int weight = 2;
            i = PreEncoded.length() - 1;
            while (i >= 0) {
                if (weight > 7) {
                    weight = 2;
                }
                sum += Integer.parseInt(String.valueOf(PreEncoded.toCharArray()[i])) * weight++;
                --i;
            }
            int mod = sum % 11;
            int checksum = mod == 0 ? 0 : 11 - mod;
            PreEncoded = String.valueOf(PreEncoded) + String.valueOf(checksum);
        }
        if (this.encodedType == Barcode.TYPE.MSI_2Mod10 || this.encodedType == Barcode.TYPE.MSI_Mod11_Mod10) {
            String odds = "";
            String evens = "";
            i = PreEncoded.length() - 1;
            while (i >= 0) {
                odds = String.valueOf(String.valueOf(PreEncoded.toCharArray()[i])) + odds;
                if (i - 1 >= 0) {
                    evens = String.valueOf(String.valueOf(PreEncoded.toCharArray()[i - 1])) + evens;
                }
                i -= 2;
            }
            odds = String.valueOf(Integer.parseInt(odds) * 2);
            evensum = 0;
            oddsum = 0;
            cArray = evens.toCharArray();
            n2 = cArray.length;
            n = 0;
            while (n < n2) {
                Character c = Character.valueOf(cArray[n]);
                evensum += Integer.parseInt(c.toString());
                ++n;
            }
            cArray = odds.toCharArray();
            n2 = cArray.length;
            n = 0;
            while (n < n2) {
                Character c = Character.valueOf(cArray[n]);
                oddsum += Integer.parseInt(c.toString());
                ++n;
            }
            int checksum = 10 - (oddsum + evensum) % 10;
            PreEncoded = String.valueOf(PreEncoded) + String.valueOf(checksum);
        }
        String result = "110";
        char[] cArray2 = PreEncoded.toCharArray();
        int n3 = cArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Character c = Character.valueOf(cArray2[n4]);
            result = String.valueOf(result) + this.MSI_Code[Integer.parseInt(c.toString())];
            ++n4;
        }
        result = String.valueOf(result) + "1001";
        return result;
    }

    public String getEncodedValue() {
        return this.encodeMSI();
    }
}

